/* -*- mode: C++; tab-width: 4 -*- */
/* ===================================================================== *\
	Copyright (c) 2000-2001 Palm, Inc. or its subsidiaries.
	All rights reserved.

	This file is part of the Palm OS Emulator.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
\* ===================================================================== */

#include "EmCommon.h"
#include "EmRegsUSBS1D13A03.h"
#include "SessionFile.h"		// WriteS1D13A03RegsType


// Given a register (specified by its field name), return its address
// in emulated space.

#define addressof(reg)				\
	(this->GetAddressStart () + fRegs.offsetof_##reg ())


// Macro to help the installation of handlers for a register.

#define INSTALL_HANDLER(read, write, reg)			\
	this->SetHandler (	(ReadFunction) &EmRegsUSBS1D13A03::read,		\
						(WriteFunction) &EmRegsUSBS1D13A03::write,		\
						addressof (reg),			\
						fRegs.reg.GetSize ())


// ---------------------------------------------------------------------------
//		 EmRegsUSBS1D13A03::EmRegsUSBS1D13A03
// ---------------------------------------------------------------------------

EmRegsUSBS1D13A03::EmRegsUSBS1D13A03 (emuptr baseAddr) :
	fBaseAddr (baseAddr)
{
}


// ---------------------------------------------------------------------------
//		 EmRegsUSBS1D13A03::~EmRegsUSBS1D13A03
// ---------------------------------------------------------------------------

EmRegsUSBS1D13A03::~EmRegsUSBS1D13A03 (void)
{
}


// ---------------------------------------------------------------------------
//		 EmRegsUSBS1D13A03::Initialize
// ---------------------------------------------------------------------------

void EmRegsUSBS1D13A03::Initialize (void)
{
	EmRegs::Initialize ();
}


// ---------------------------------------------------------------------------
//		 EmRegsUSBS1D13A03::Reset
// ---------------------------------------------------------------------------

void EmRegsUSBS1D13A03::Reset (Bool hardwareReset)
{
	EmRegs::Reset (hardwareReset);

	if (hardwareReset)
	{
		memset (fRegs.GetPtr (), 0, fRegs.GetSize ());
	}
}


// ---------------------------------------------------------------------------
//		 EmRegsUSBS1D13A03::Save
// ---------------------------------------------------------------------------

void EmRegsUSBS1D13A03::Save (SessionFile& f)
{
	EmRegs::Save (f);
}


// ---------------------------------------------------------------------------
//		 EmRegsUSBS1D13A03::Load
// ---------------------------------------------------------------------------

void EmRegsUSBS1D13A03::Load (SessionFile& f)
{
	EmRegs::Load (f);
}


// ---------------------------------------------------------------------------
//		 EmRegsUSBS1D13A03::Dispose
// ---------------------------------------------------------------------------

void EmRegsUSBS1D13A03::Dispose (void)
{
	EmRegs::Dispose ();
}


// ---------------------------------------------------------------------------
//		 EmRegsUSBS1D13A03::SetSubBankHandlers
// ---------------------------------------------------------------------------

void EmRegsUSBS1D13A03::SetSubBankHandlers (void)
{
	// Install base handlers.

	EmRegs::SetSubBankHandlers ();

	// Now add standard/specialized handers for the defined registers.

	INSTALL_HANDLER (StdReadBE,			StdWriteBE,				control);
	INSTALL_HANDLER (StdReadBE,			StdWriteBE,				endpoint1ReceiveMailboxData);
	INSTALL_HANDLER (StdReadBE,			StdWriteBE,				pinInputStatusPinOutputData);
}


// ---------------------------------------------------------------------------
//		 EmRegsUSBS1D13A03::GetRealAddress
// ---------------------------------------------------------------------------

uint8* EmRegsUSBS1D13A03::GetRealAddress (emuptr address)
{
	return (uint8*) fRegs.GetPtr () + address - this->GetAddressStart ();
}


// ---------------------------------------------------------------------------
//		 EmRegsUSBS1D13A03::GetAddressStart
// ---------------------------------------------------------------------------

emuptr EmRegsUSBS1D13A03::GetAddressStart (void)
{
	return fBaseAddr;
}


// ---------------------------------------------------------------------------
//		 EmRegsUSBS1D13A03::GetAddressRange
// ---------------------------------------------------------------------------

uint32 EmRegsUSBS1D13A03::GetAddressRange (void)
{
	return fRegs.GetSize ();
}